// Verilog code for sinc filter, with N = 128
// Fnull = 0.0078125Fs
// This is a pipeline implementation
// 18 bit data words
// DJS 8/30/16

module sinc_128 (
  clk,
  din,
  dout
);

input clk;
input [17:0] din; 						//unfiltered sample

output [17:0] dout; 						//filtered sample
							 
reg [2303:0] shift_reg;
reg [17:0] dout;

initial 
  shift_reg = 0;

wire [24:0] regout_a [63:0];
wire [24:0] regout_b [31:0];
wire [24:0] regout_c [15:0];
wire [24:0] regout_d [7:0];
wire [24:0] regout_e [3:0];
wire [24:0] regout_f [1:0];
wire [24:0] regout;

always @(posedge clk) //load the newest bit into the serial bit array on each rising edge of 'clk'
begin
	shift_reg <= {shift_reg[2285:0],din};
	
	//divide the result by 128
	dout <= regout[24:7];
end

genvar j;
generate
for(j = 0;j < 64;j = j+1)
begin: echelon_a
  assign regout_a[j] = {{7{shift_reg[j*18+17]}},shift_reg[j*18+17:j*18]} + {{7{shift_reg[(j+64)*18+17]}},shift_reg[(j+64)*18+17:(j+64)*18]};
end

for(j = 0;j < 32;j = j+1)
begin: echelon_b
  assign regout_b[j] = regout_a[j] + regout_a[j+32];
end

for(j = 0;j < 16;j = j+1)
begin: echelon_c
  assign regout_c[j] = regout_b[j] + regout_b[j+16];
end

for(j = 0;j < 8;j = j+1)
begin: echelon_d
  assign regout_d[j] = regout_c[j] + regout_c[j+8];
end

for(j = 0;j < 4;j = j+1)
begin: echelon_e
  assign regout_e[j] = regout_d[j] + regout_d[j+4];
end

for(j = 0;j < 2;j = j+1)
begin: echelon_f
  assign regout_f[j] = regout_e[j] + regout_e[j+2];
end
endgenerate

assign regout = regout_f[0] + regout_f[1];

endmodule